local mvec3_copy = mvector3.copy
local dis_sq = mvector3.distance_sq

Hooks:PostHook(PlayerManager,"check_skills","gamblerking_playermanager_checkskills",function(self)

	if self:has_category_upgrade("player","chance_change_nine") then 
		local upgrade_data = self:upgrade_value("player","chance_change_nine")
		local gain_health_percent = upgrade_data.health_restored
		local cooldown = upgrade_data.cooldown
		
		self:register_message(Message.OnEnemyKilled,"gamblerking_on_enemy_killed_restore_health",
			function(equipped_unit,variant,killed_unit)
				if not self:has_active_temporary_property("gamblerking_health_on_kill_cooldown") then 
					local heal_chance = math.random()
					local player = self:local_player()
					if alive(player) then
						if heal_chance > 0.8 then
							self:activate_temporary_property("gamblerking_health_on_kill_cooldown",cooldown,true) --set effect cooldown timer
							local dmg_ext = player:character_damage()
							dmg_ext:restore_health(gain_health_percent,false,true)
						end
					end
				end
			end
		)
	else
		self:unregister_message(Message.OnEnemyKilled,"gamblerking_on_enemy_killed_restore_health")
	end
end)